#include <Windows.h>
#include <iostream>
#include <string>

using namespace std;

int getDirectorySize(const char* c_path){
	HANDLE fh;
	WIN32_FIND_DATA	fd;
	int size = 0;
	string path = c_path;

	fh = FindFirstFile((path + "\\*").c_str(), &fd);
	if(fh != INVALID_HANDLE_VALUE){
		while(FindNextFile(fh, &fd)){
			if( (fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) && strcmp(fd.cFileName, "..") && strcmp(fd.cFileName, ".")){
				size += getDirectorySize((path + "\\" + fd.cFileName).c_str());
			} else {
				size += (fd.nFileSizeHigh * MAXDWORD) + fd.nFileSizeLow;											
			}
			
		}
		FindClose(fh);
	}

	return size;
}

int main(){
	char* path = "C:\\test";
	cout << "Size of '" << path << "': " << getDirectorySize(path) << " bytes" << endl;

	system("pause");

	return 0;
}