<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <html>
            <body>

                <h1>Рабочая учебная программа по дисциплине "Теория алгоритмов"</h1>

                <div>
                    <h2>Пояснительная записка</h2>
                    <xsl:value-of select="program/note" />
                </div>

                <div>
                    <h2>Учебно-тематическое</h2>
                    <xsl:for-each select="program/planning/program_type">
                        <h3><xsl:value-of select="name"/> форма обучения</h3>
                        <table border="1">
                            <tr>
                                <th rowspan="2">Наименование раздела, темы</th>
                                <th rowspan="2">Всего трудоемкость</th>
                                <th colspan="4">Аудиторные занятия</th>
                                <th rowspan="2">Самостоятельная работа</th>
                            </tr>
                            <tr>
                                <th>Всего</th>
                                <th>Лекции</th>
                                <th>Практические</th>
                                <th>Лабораторные</th>
                            </tr>

                            <xsl:for-each select="subject_list/subject">
                                <tr>
                                    <td><xsl:value-of select="name"/></td>
                                    <td><xsl:value-of select="classroom_time/lections_time + classroom_time/practice_time + classroom_time/labs_time + independent_time"/></td>
                                    <td><xsl:value-of select="classroom_time/lections_time + classroom_time/practice_time + classroom_time/labs_time"/></td>
                                    <td><xsl:value-of select="classroom_time/lections_time"/></td>
                                    <td><xsl:value-of select="classroom_time/practice_time"/></td>
                                    <td><xsl:value-of select="classroom_time/labs_time"/></td>
                                    <td><xsl:value-of select="independent_time"/></td>
                                </tr>
                            </xsl:for-each>
                        </table>
                    </xsl:for-each>
                </div>

                <div>
                    <h2>Содержание дисциплины</h2>
                    <ol>
                        <xsl:for-each select="program/content/subject_content">
                            <li>
                                <xsl:value-of select="name"/>
                                <ul>
                                    <xsl:for-each select="list/name">
                                        <li><xsl:value-of select="self::name" /></li>
                                    </xsl:for-each>
                                </ul>
                            </li>
                        </xsl:for-each>
                    </ol>
                </div>

                <div>
                    <h2>Самостоятельная работа и организация контрольно-оценочной деятельности</h2>
                    <ul>
                        <xsl:for-each select="program/extra/extra_block">
                            <li>
                                <xsl:value-of select="name"/>:
                                <ol>
                                    <xsl:for-each select="list/name">
                                        <li><xsl:value-of select="self::name" /></li>
                                    </xsl:for-each>
                                </ol>
                            </li>
                        </xsl:for-each>
                    </ul>
                </div>

                <div>
                    <h2>Требования к уровню освоения содержания дисциплины</h2>
                    <div>
                        <h3>Студент, изучивший дисциплину, должен знать:</h3>
                        <xsl:value-of select="program/requirements/must_know" />
                    </div>
                    <div>
                        <h3>Студент, изучивший дисциплину, должен уметь:</h3>
                        <xsl:value-of select="program/requirements/must_beableto" />
                    </div>
                </div>

                <div>
                    <h2>Учебно-метадическое и информационное обеспечение дисциплины</h2>

                    <div>
                        <h3>Рекомендуемая литература</h3>
                        <div>
                            <h4>Основная:</h4>
                            <ol>
                                <xsl:for-each select="program/supply/literature/primary/list/name">
                                    <li><xsl:value-of select="self::name" /></li>
                                </xsl:for-each>
                            </ol>
                        </div>
                        <div>
                            <h4>Дополнительная:</h4>
                            <ol>
                                <xsl:for-each select="program/supply/literature/additional/list/name">
                                    <li><xsl:value-of select="self::name" /></li>
                                </xsl:for-each>
                            </ol>
                        </div>
                    </div>

                    <div>
                        <h3>Информационное обеспечение дисциплины</h3>
                        <ul>
                            <xsl:for-each select="program/supply/information/list/name">
                                <li><xsl:value-of select="self::name" /></li>
                            </xsl:for-each>
                        </ul>
                    </div>
                </div>

                <div>
                    <h2>Материально-техническое и дидактическое обеспечение дисциплины</h2>
                    <ul>
                        <xsl:for-each select="program/supply/technique/list/name">
                            <li><xsl:value-of select="self::name" /></li>
                        </xsl:for-each>
                    </ul>
                </div>

                <div>
                    <h2>Сведения об авторе программы</h2>
                    <div>
                        <span><xsl:value-of select="program/program_author/name" /></span><br />
                        <span><xsl:value-of select="program/program_author/post" /></span><br />
                        Рабочий телефон: <span><xsl:value-of select="program/program_author/phone" /></span><br />
                    </div>
                </div>

            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>